PSCAD 4.2.0

Settings
 {
 Id = "940000410.1144790938"
 Author = "gdi.jayas"
 Desc = "Simple case illustrating interpolation"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.2
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144790925
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,16,[597,467],100)
   {
   -Sticky-([90,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 90,108,504,450
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Interpolation is an integral part of EMTDC which allows switching devices to switch at any instant of time instead of only on the regular time step grid. This allows the use of a larger time step without missing current zeroes or other switching instants.

This circuit shows the simplest form of forced commutation.  A dc current will flow into the inductor, slowing reaching its steady state condition.  When the gto device turns off, the current from the source will go to 0.0.  The current in the inductor cannot change instantaneously however, so a large -ve voltage (due to L.di/dt ) is generated, resulting in the back diode turning on immediately.

With fixed time step programs however, the diode will not turn on until the end of the time step.  This means that the current in the inductor is reduced to zero. The result is a large voltage spike (of one time step duration), and the inductor current is re-set to 0.0.

The EMTDC program uses interpolation, so the diode will turn on at exactly 0.0 voltage, not at the end of the time step.  The result is that the inductor current continues to flow in the diode without interruption.
"
    }
   -Wire-([270,468],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.inductor([360,504],1,0,-1)
    {
    L = ".1 [H]"
    }
   -Wire-([360,468],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ground([360,576],1,0,-1)
    {
    }
   -Wire-([144,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([198,666],0,25535032,50)
    {
    Name = "V1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "10.0"
    }
   0.datalabel([144,666],0,0,-1)
    {
    Name = "V1"
    }
   0.ammeter([360,540],1,0,30)
    {
    Name = "IL"
    }
   -Wire-([306,702],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([360,702],0,25540136,70)
    {
    Name = "IL"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "8"
    }
   0.datalabel([306,702],0,0,-1)
    {
    Name = "IL"
    }
   -Wire-([126,468],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([306,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([360,666],0,25544808,60)
    {
    Name = "VL"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "10"
    }
   0.datalabel([306,666],0,0,-1)
    {
    Name = "VL"
    }
   0.datalabel([270,846],0,0,-1)
    {
    Name = "GtoSgn"
    }
   -Wire-([144,702],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([198,702],0,25549656,160)
    {
    Name = "IGto"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "8"
    }
   0.datalabel([144,702],0,0,-1)
    {
    Name = "IGto"
    }
   -Wire-([396,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([432,810],0,0,-1)
    {
    Name = "TOpen"
    }
   0.var([360,810],0,25554848,90)
    {
    Name = "TOpen"
    Group = ""
    Display = "0"
    Max = ".2"
    Min = "0.0"
    Value = "0.09"
    Units = "s"
    Collect = "1"
    }
   -Wire-([396,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([432,846],0,0,-1)
    {
    Name = "TClose"
    }
   0.var([360,846],0,25559000,110)
    {
    Name = "TClose"
    Group = ""
    Display = "0"
    Max = ".2"
    Min = "0.0"
    Value = "0.14"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([360,900],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(25554848)
    Slider(25559000)
    }
   -Wire-([144,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([198,738],0,25579712,150)
    {
    Name = "GtoSgn"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([144,738],0,0,-1)
    {
    Name = "GtoSgn"
    }
   -Wire-([396,468],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,576],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,576],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([396,504],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.peswitch([396,540],0,0,40)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.0005 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([306,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([360,738],0,25587544,80)
    {
    Name = "Id"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "8"
    }
   0.datalabel([306,738],0,0,-1)
    {
    Name = "Id"
    }
   0.source_1([126,540],1,0,-1)
    {
    Name = "Source1"
    Type = "1"
    Grnd = "1"
    Spec = "0"
    Cntrl = "0"
    AC = "0"
    Vm = "10 [kV]"
    Tc = "0.0 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0"
    Q = "0.0"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Sticky-([558,90],0)
    {
    Name = ""
    Font = 1
    Bounds = 558,90,1080,324
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\

If interpolation is turned off (Project Settings->Simulation-> Interpolate switching events to the precise time), then the inductor current is interrupted for one time step.  This will result in a large di/dt voltage spike.  The spike is artificial because the diode should immediately conduct.

Solutions for fixed time step programs (without interpolation) is to add large snubber RC circuits across the diode to absorb the spike.

With the EMTDC interpolation algorithm, the result is correct, even if no RC snubber is used.  The EMTDC solution is completely general and will work for any configuration.

This simulation case also has an inductive node, therefore when the gto turns off the solution will also be corrupted unless a chatter elimination technique is used. 

For details about chatter elimination see a case 'chatter.psc'.
"
    }
   0.peswitch([234,468],1,0,140)
    {
    L = "G"
    Type = "2"
    SNUB = "0"
    INTR = "0"
    RON = "0.0005 [ohm]"
    ROFF = "1.0E12 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IGto"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([270,504],0,0,-1)
    {
    Name = "GtoSgn"
    }
   0.range([198,846],0,0,120)
    {
    XL = "TOpen"
    XU = "TClose"
    OL = "1"
    OM = "0"
    OH = "1"
    COM = "Band_Compare"
    }
   0.time-sig([126,846],0,0,100)
    {
    }
   0.unity([270,846],0,0,130)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([126,468],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([288,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 288,18,954,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "SIMPLE GTO DEVICE USING INTERPOLATION"
    }
   -Plot-([558,396],0)
    {
    Title = "Inductor V and I, IGto, GtoSgn"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,522,630
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,522,133],"Voltage")
     {
     Options = 8
     Units = "kV"
     Curve(25544808,"VL",0,,,)
     }
    Graph([0,133],[0,0,522,133],"Current")
     {
     Options = 8
     Units = "kA"
     Curve(25540136,"IL",0,,,)
     Curve(25587544,"Id",1,,,)
     }
    Graph([0,266],[0,0,522,133],"Current")
     {
     Options = 8
     Units = "kA"
     Curve(25549656,"IGto",0,,,)
     }
    DGraph([0,399],[0,0,522,168],"DigitalGraph")
     {
     Options = 2
     Curve(25579712,"GtoSgn",0,,,)
     }
    }
   0.voltmetergnd([162,468],0,0,10)
    {
    Name = "V1"
    }
   0.voltmetergnd([324,468],0,0,20)
    {
    Name = "VL"
    }
   }
  }
 }

